/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.debug.ui.internal.launchConfigurations;

import com.aptana.core.CoreStrings;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.StringUtil;
import com.aptana.debug.ui.internal.ActiveResourcePathGetterAdapter;
import com.aptana.js.debug.core.JSLaunchConfigurationHelper;
import com.aptana.js.debug.ui.JSDebugUIPlugin;
import com.aptana.js.debug.ui.internal.launchConfigurations.Messages;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class LaunchServerSettingsTab
extends AbstractLaunchConfigurationTab {
    private static final Pattern HOST_PATTERN = Pattern.compile("^(\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3})|([-\\w]+(\\.[-\\w+])*)(:\\d{4,7})?$");
    private Listener dirtyListener;
    private Image image;
    private Text fServerHostText;
    private Button rbCurrentPage;
    private Button rbSpecificPage;
    private Button bSpecificPageBrowse;
    private Text fSpecificPageText;
    private Button rbStartUrl;
    private Text fStartUrlText;
    private Button rbInternalServer;
    private Button rbCustomServer;
    private Text fbaseUrlText;

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        this.setControl((Control)composite);
        GridLayout topLayout = new GridLayout();
        topLayout.verticalSpacing = 5;
        composite.setLayout((Layout)topLayout);
        composite.setFont(font);
        this.dirtyListener = new Listener(){

            public void handleEvent(Event event) {
                LaunchServerSettingsTab.this.updateEnablement();
                LaunchServerSettingsTab.this.setDirty(true);
                LaunchServerSettingsTab.this.updateLaunchConfigurationDialog();
            }
        };
        this.createServerHostSection(composite);
        this.createStartActionSection(composite);
        this.createServerSection(composite);
        this.hookListeners(true);
    }

    private void createServerHostSection(Composite parent) {
        Font font = parent.getFont();
        Group group = new Group(parent, 0x800004);
        group.setText(Messages.LaunchServerSettingsTab_Server);
        group.setFont(font);
        GridData gd = new GridData(4, 20, true, false);
        group.setLayoutData((Object)gd);
        FormLayout form = new FormLayout();
        group.setLayout((Layout)form);
        form.marginTop = 10;
        form.marginBottom = 10;
        form.marginLeft = 10;
        form.marginRight = 10;
        int column1Offset = 0;
        int column2Offset = 135;
        Label hostLabel = new Label((Composite)group, 0);
        hostLabel.setText(Messages.LaunchServerSettingsTab_Host);
        FormData data = new FormData();
        data.left = new FormAttachment(0, column1Offset);
        hostLabel.setLayoutData((Object)data);
        this.fServerHostText = new Text((Composite)group, 2052);
        data = new FormData();
        data.top = new FormAttachment((Control)hostLabel, 0, 128);
        data.left = new FormAttachment(0, column2Offset);
        data.right = new FormAttachment(100, 0);
        this.fServerHostText.setLayoutData((Object)data);
    }

    private void createStartActionSection(Composite parent) {
        Font font = parent.getFont();
        Group group = new Group(parent, 0x800004);
        group.setText(Messages.LaunchBrowserSettingsTab_StartAction);
        group.setFont(font);
        GridData gd = new GridData(4, 20, true, false);
        group.setLayoutData((Object)gd);
        FormLayout form = new FormLayout();
        group.setLayout((Layout)form);
        form.marginTop = 10;
        form.marginBottom = 10;
        form.marginLeft = 10;
        form.marginRight = 10;
        int column1Offset = 0;
        int column2Offset = 135;
        this.rbCurrentPage = new Button((Composite)group, 16);
        this.rbCurrentPage.setText(Messages.LaunchBrowserSettingsTab_UseCurrentPage);
        FormData data = new FormData();
        data.left = new FormAttachment(0, column1Offset);
        this.rbCurrentPage.setLayoutData((Object)data);
        this.rbSpecificPage = new Button((Composite)group, 16);
        this.rbSpecificPage.setText(Messages.LaunchBrowserSettingsTab_SpecificPage);
        data = new FormData();
        data.top = new FormAttachment((Control)this.rbCurrentPage, 10, 1024);
        data.left = new FormAttachment(0, column1Offset);
        this.rbSpecificPage.setLayoutData((Object)data);
        this.bSpecificPageBrowse = new Button((Composite)group, 8);
        this.bSpecificPageBrowse.setText(StringUtil.ellipsify((String)CoreStrings.BROWSE));
        data = new FormData();
        data.top = new FormAttachment((Control)this.rbSpecificPage, -1, 128);
        data.right = new FormAttachment(100, 0);
        this.bSpecificPageBrowse.setLayoutData((Object)data);
        this.fSpecificPageText = new Text((Composite)group, 2052);
        data = new FormData();
        data.top = new FormAttachment((Control)this.rbSpecificPage, 0, 128);
        data.left = new FormAttachment(0, column2Offset);
        data.right = new FormAttachment((Control)this.bSpecificPageBrowse, -5, 16384);
        this.fSpecificPageText.setLayoutData((Object)data);
        this.rbStartUrl = new Button((Composite)group, 16);
        this.rbStartUrl.setText(Messages.LaunchBrowserSettingsTab_StartURL);
        data = new FormData();
        data.top = new FormAttachment((Control)this.rbSpecificPage, 10, 1024);
        data.left = new FormAttachment(0, column1Offset);
        this.rbStartUrl.setLayoutData((Object)data);
        this.fStartUrlText = new Text((Composite)group, 2052);
        data = new FormData();
        data.top = new FormAttachment((Control)this.rbStartUrl, 0, 128);
        data.left = new FormAttachment(0, column2Offset);
        data.right = new FormAttachment(100, 0);
        this.fStartUrlText.setLayoutData((Object)data);
        this.bSpecificPageBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IResource resource = LaunchServerSettingsTab.this.chooseWorkspaceLocation();
                if (resource != null) {
                    LaunchServerSettingsTab.this.fSpecificPageText.setText(resource.getFullPath().toPortableString());
                }
            }
        });
    }

    private void createServerSection(Composite parent) {
        Font font = parent.getFont();
        Group group = new Group(parent, 0x800000);
        group.setText(Messages.LaunchBrowserSettingsTab_Server);
        group.setFont(font);
        GridData gd = new GridData(4, 20, true, false);
        group.setLayoutData((Object)gd);
        FormLayout form = new FormLayout();
        group.setLayout((Layout)form);
        form.marginTop = 10;
        form.marginBottom = 10;
        form.marginLeft = 10;
        form.marginRight = 10;
        int column1Offset = 0;
        int column3Offset = 135;
        this.rbInternalServer = new Button((Composite)group, 16);
        this.rbInternalServer.setText(Messages.LaunchBrowserSettingsTab_UseBuiltInWebServer);
        FormData data = new FormData();
        data.left = new FormAttachment(0, column1Offset);
        this.rbInternalServer.setLayoutData((Object)data);
        this.rbCustomServer = new Button((Composite)group, 16);
        this.rbCustomServer.setText(Messages.LaunchBrowserSettingsTab_UseExternalWebServer);
        data = new FormData();
        data.top = new FormAttachment((Control)this.rbInternalServer, 10, 1024);
        data.left = new FormAttachment(0, column1Offset);
        this.rbCustomServer.setLayoutData((Object)data);
        this.fbaseUrlText = new Text((Composite)group, 2052);
        data = new FormData();
        data.top = new FormAttachment((Control)this.rbCustomServer, 10, 1024);
        data.left = new FormAttachment(0, column3Offset);
        data.right = new FormAttachment(100, 0);
        this.fbaseUrlText.setLayoutData((Object)data);
        Label baseUrlLabel = new Label((Composite)group, 0);
        baseUrlLabel.setText(Messages.LaunchBrowserSettingsTab_BaseURL);
        baseUrlLabel.setAlignment(131072);
        data = new FormData();
        data.right = new FormAttachment((Control)this.fbaseUrlText, -8, 16384);
        data.top = new FormAttachment((Control)this.fbaseUrlText, 0, 128);
        baseUrlLabel.setLayoutData((Object)data);
    }

    private void hookListeners(boolean hook) {
        if (hook) {
            this.fServerHostText.addListener(24, this.dirtyListener);
            this.fSpecificPageText.addListener(24, this.dirtyListener);
            this.fStartUrlText.addListener(24, this.dirtyListener);
            this.rbCurrentPage.addListener(13, this.dirtyListener);
            this.rbSpecificPage.addListener(13, this.dirtyListener);
            this.rbStartUrl.addListener(13, this.dirtyListener);
            this.fbaseUrlText.addListener(24, this.dirtyListener);
            this.rbInternalServer.addListener(13, this.dirtyListener);
            this.rbCustomServer.addListener(13, this.dirtyListener);
        } else {
            this.fServerHostText.removeListener(24, this.dirtyListener);
            this.fSpecificPageText.removeListener(24, this.dirtyListener);
            this.fStartUrlText.removeListener(24, this.dirtyListener);
            this.rbCurrentPage.removeListener(13, this.dirtyListener);
            this.rbSpecificPage.removeListener(13, this.dirtyListener);
            this.rbStartUrl.removeListener(13, this.dirtyListener);
            this.fbaseUrlText.removeListener(24, this.dirtyListener);
            this.rbInternalServer.removeListener(13, this.dirtyListener);
            this.rbCustomServer.removeListener(13, this.dirtyListener);
        }
    }

    private void updateEnablement() {
        this.fSpecificPageText.setEnabled(this.rbSpecificPage.getSelection());
        this.bSpecificPageBrowse.setEnabled(this.rbSpecificPage.getSelection());
        this.fStartUrlText.setEnabled(this.rbStartUrl.getSelection());
        this.rbInternalServer.setEnabled(!this.rbStartUrl.getSelection());
        this.rbCustomServer.setEnabled(!this.rbStartUrl.getSelection());
        this.fbaseUrlText.setEnabled(this.rbCustomServer.isEnabled() && this.rbCustomServer.getSelection());
    }

    private IResource chooseWorkspaceLocation() {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        dialog.setComparator((ViewerComparator)new ResourceComparator(1));
        dialog.setMessage(Messages.LaunchBrowserSettingsTab_ChooseFile);
        dialog.open();
        Object result = dialog.getFirstResult();
        return (IResource)result;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        JSLaunchConfigurationHelper.setServerDefaults((ILaunchConfigurationWorkingCopy)configuration);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.hookListeners(false);
        try {
            try {
                this.fServerHostText.setText(configuration.getAttribute("serverHost", ""));
                int startActionType = configuration.getAttribute("startActionType", 1);
                this.rbCurrentPage.setSelection(startActionType == 1);
                this.rbSpecificPage.setSelection(startActionType == 2);
                this.fSpecificPageText.setText(configuration.getAttribute("startPagePath", ""));
                this.rbStartUrl.setSelection(startActionType == 3);
                this.fStartUrlText.setText(configuration.getAttribute("startPageUrl", ""));
                int serverType = configuration.getAttribute("serverType", 1);
                this.rbInternalServer.setSelection(serverType == 1);
                this.rbCustomServer.setSelection(serverType == 3);
                this.fbaseUrlText.setText(configuration.getAttribute("externalBaseUrl", ""));
            }
            catch (CoreException e) {
                IdeLog.logError((Plugin)JSDebugUIPlugin.getDefault(), (String)"Reading launch configuration fails", (Throwable)e);
                this.hookListeners(true);
                this.updateEnablement();
            }
        }
        finally {
            this.hookListeners(true);
            this.updateEnablement();
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        String value = this.fServerHostText.getText();
        configuration.setAttribute("serverHost", value);
        int startActionType = 0;
        if (this.rbCurrentPage.getSelection()) {
            startActionType = 1;
        } else if (this.rbSpecificPage.getSelection()) {
            startActionType = 2;
        } else if (this.rbStartUrl.getSelection()) {
            startActionType = 3;
        }
        configuration.setAttribute("startActionType", startActionType);
        value = this.fSpecificPageText.getText();
        configuration.setAttribute("startPagePath", value);
        value = this.fStartUrlText.getText();
        configuration.setAttribute("startPageUrl", value);
        int serverType = 0;
        if (this.rbInternalServer.getSelection()) {
            serverType = 1;
        } else if (this.rbCustomServer.getSelection()) {
            serverType = 3;
        }
        configuration.setAttribute("serverType", serverType);
        value = this.fbaseUrlText.getText();
        configuration.setAttribute("externalBaseUrl", value);
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        IPath activeResource;
        this.setErrorMessage(null);
        this.setMessage(null);
        String value = this.fServerHostText.getText();
        if (!HOST_PATTERN.matcher(value).matches()) {
            this.setErrorMessage(Messages.LaunchServerSettingsTab_Error_ValidServerRequired);
            return false;
        }
        if (this.rbSpecificPage.getSelection()) {
            value = this.fSpecificPageText.getText();
            if (value.length() == 0 || ResourcesPlugin.getWorkspace().getRoot().findMember(value) == null) {
                this.setErrorMessage(Messages.LaunchBrowserSettingsTab_StartPageShouldBeSpecified);
                return false;
            }
        } else if (this.rbStartUrl.getSelection()) {
            value = this.fStartUrlText.getText();
            try {
                new URL(value);
            }
            catch (MalformedURLException e) {
                this.setErrorMessage(Messages.LaunchBrowserSettingsTab_ValidStartPageURLShouldBeSpecified);
                return false;
            }
        }
        if (this.rbCustomServer.getSelection()) {
            value = this.fbaseUrlText.getText();
            try {
                new URL(value);
            }
            catch (MalformedURLException e) {
                this.setErrorMessage(Messages.LaunchBrowserSettingsTab_ValidBaseURLShouldBeSpecified);
                return false;
            }
        }
        if (this.rbCurrentPage.getSelection() && (activeResource = new ActiveResourcePathGetterAdapter().getActiveResourcePath()) == null) {
            this.setMessage(Messages.LaunchBrowserSettingsTab_NoFilesOpenedInEditor);
            return false;
        }
        return true;
    }

    public String getName() {
        return Messages.LaunchBrowserSettingsTab_Main;
    }

    public Image getImage() {
        if (this.image == null) {
            this.image = JSDebugUIPlugin.getImageDescriptor("icons/full/obj16/launch-httpServer.gif").createImage();
        }
        return this.image;
    }

    public void dispose() {
        if (this.image != null) {
            this.image.dispose();
        }
        super.dispose();
    }
}

